/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.beans;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.concord.swing.beans.PropertySheet;

class PropertyInterimPanel
extends Panel {
    PropertySheet ps;
    JScrollBar vScrollBar;
    int currScrollValue = 0;
    int deltaScrollbar = 0;
    int maxSize = 300;
    private boolean wasAddNotify = false;
    private int needSizeH;

    public PropertyInterimPanel(Object o, String panelName) {
        this(o, panelName, null);
    }

    public PropertyInterimPanel(Object o, String panelName, Hashtable validProps) {
        try {
            this.ps = new PropertySheet(o, panelName, false, validProps);
            this.setLayout(null);
            this.add((Component)this.ps, "Center");
            this.ps.setLocation(0, 0);
            Dimension d = this.ps.getPreferredSize();
            this.ps.setSize(d);
            this.setSize(d.width, d.height);
        }
        catch (IllegalArgumentException e) {
            Toolkit.getDefaultToolkit().beep();
            throw e;
        }
        catch (Exception e) {
            System.out.println("PropertyDialog Exception " + e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        this.wasAddNotify = true;
        this.ps.setLocation(0, 0);
        Dimension d = this.ps.getPreferredSize();
        this.ps.setSize(d);
        this.setSize(d.width, d.height);
        PropertyInterimPanel propertyInterimPanel = this;
        synchronized (propertyInterimPanel) {
            this.defineScrollBar(this.needSizeH);
        }
    }

    public synchronized int defineScrollBar(int needSizeH) {
        this.needSizeH = needSizeH;
        if (this.vScrollBar != null) {
            this.remove(this.vScrollBar);
        }
        int insetsH = this.getInsets().top + this.getInsets().bottom;
        int panelSize = this.ps.getSize().height;
        this.vScrollBar = new JScrollBar();
        int scrollW = this.vScrollBar.getPreferredSize().width;
        this.vScrollBar.setLocation(this.getSize().width + 1, 0);
        this.vScrollBar.setSize(scrollW, needSizeH - insetsH);
        this.add(this.vScrollBar);
        int visisbleSize = needSizeH - insetsH;
        this.deltaScrollbar = visisbleSize - panelSize;
        this.vScrollBar.setMaximum(panelSize);
        this.vScrollBar.setVisibleAmount(visisbleSize);
        this.vScrollBar.setUnitIncrement((int)Math.ceil((float)visisbleSize / 20.0f));
        this.vScrollBar.setBlockIncrement(visisbleSize / 5);
        this.vScrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof BoundedRangeModel) {
                    BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                    int newValue = model.getValue();
                    if (newValue == PropertyInterimPanel.this.currScrollValue) {
                        return;
                    }
                    PropertyInterimPanel.this.currScrollValue = newValue;
                    float k = (float)PropertyInterimPanel.this.currScrollValue / (float)(PropertyInterimPanel.this.vScrollBar.getMaximum() - PropertyInterimPanel.this.vScrollBar.getVisibleAmount()) * (float)PropertyInterimPanel.this.deltaScrollbar;
                    PropertyInterimPanel.this.ps.setLocation(PropertyInterimPanel.this.ps.getLocation().x, Math.round(k));
                    PropertyInterimPanel.this.invalidate();
                    PropertyInterimPanel.this.repaint();
                }
            }
        });
        return scrollW + 3;
    }

    public void initialize(Object o) {
        this.ps.initialize(o);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.ps == null) {
            return super.getPreferredSize();
        }
        Dimension d = this.ps.getPreferredSize();
        if (this.vScrollBar != null) {
            d.width += this.vScrollBar.getSize().width;
        }
        return d;
    }

    public void restoreOldValues() {
        if (this.ps != null) {
            this.ps.restoreOldValues();
        }
    }

    public void writeNewValues() {
        if (this.ps != null) {
            this.ps.writeNewValues();
        }
    }
}

