/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.concord.swing.graph.ValueGraph;

public class Gauge
extends JComponent
implements ValueGraph {
    public static final double DEFAULT_MIN_VALUE = 0.0;
    public static final double DEFAULT_MAX_VALUE = 100.0;
    public static final double DEFAULT_VALUE = 100.0 / (double)colors.length;
    protected double min = 0.0;
    protected double max = 100.0;
    protected double[] values = new double[]{DEFAULT_VALUE};
    protected double range = this.max - this.min;
    protected int gaugeWidth;
    protected int gaugeHeight;
    protected int majorTicks = 0;
    protected int minorTicks = 0;
    protected int tickSpace = 2;
    protected int majorTickLength = 10;
    protected int minorTickLength = 6;
    protected int majorTickValue;
    protected int minorTickValue;
    protected String[] valueStrings = new String[]{"" + this.values[0]};
    protected String minString = "" + this.min;
    protected String maxString = "" + this.max;
    protected boolean editable = false;
    protected boolean drawBoundary = false;
    protected Vector oldBars = new Vector();
    protected Rectangle[] bars = new Rectangle[]{new Rectangle()};
    protected Color[] barColors = new Color[]{Color.red};
    protected int numberOfBars = this.bars.length;
    protected int[] gaugeValues = new int[this.bars.length];
    protected ComponentAdapter sizeChanged = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            Gauge.this.setGaugeSize(Gauge.this.getSize());
        }
    };
    protected MouseMotionAdapter dragGauge = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent event) {
            Gauge.this.setValueFromMouseEvent(event);
        }
    };
    protected MouseAdapter setGauge = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent event) {
            Gauge.this.setValueFromMouseEvent(event);
        }
    };

    public Gauge() {
        this.addComponentListener(this.sizeChanged);
        this.updateValue(this.values[0]);
        this.setEditable(this.editable);
    }

    protected int findBarIndex(int x, int y) {
        int i = 0;
        while (i < this.bars.length) {
            if (this.bars[i].contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected double getBarValue(int index, int x, int y) {
        Rectangle bar = this.bars[index];
        double barRange = (double)bar.height * this.range / (double)this.gaugeHeight;
        double barValue = barRange - (double)(y - bar.y) * barRange / (double)bar.height;
        return barValue;
    }

    protected void setValueFromMouseEvent(MouseEvent event) {
        int y;
        int x = event.getX();
        int index = this.findBarIndex(x, y = event.getY());
        if (index == -1) {
            index = this.bars.length - 1;
        }
        Rectangle bar = this.bars[index];
        if (y - bar.y > bar.height / 2) {
            --index;
        }
        if (index < 0) {
            index = 0;
        }
        this.updateValue(this.getBarValue(index, x, y), index);
        this.repaint();
    }

    protected void setGaugeSize(Dimension size) {
        this.gaugeWidth = this.majorTicks > 0 && this.minorTicks > 0 ? (int)(0.35 * (double)size.width) : size.width;
        this.gaugeHeight = size.height;
        int i = 0;
        while (i < this.gaugeValues.length) {
            this.gaugeValues[i] = (int)(this.values[i] * (double)this.gaugeHeight / this.range);
            this.updateValue(this.getValue(i), i);
            ++i;
        }
        this.setMajorTickMarks(this.majorTicks);
    }

    public void setNumberOfBars(int number) {
        int i;
        if (this.bars != null) {
            i = 0;
            while (i < this.bars.length) {
                this.oldBars.addElement(this.bars[i]);
                this.bars[i] = null;
                ++i;
            }
        }
        this.numberOfBars = number;
        this.bars = new Rectangle[number];
        this.barColors = new Color[number];
        this.values = new double[number];
        this.gaugeValues = new int[number];
        i = 0;
        while (i < number) {
            if (this.oldBars.size() > 0) {
                this.bars[i] = (Rectangle)this.oldBars.elementAt(0);
                this.oldBars.removeElementAt(0);
            } else {
                this.bars[i] = new Rectangle();
            }
            this.barColors[i] = colors[i % colors.length];
            this.values[i] = DEFAULT_VALUE;
            ++i;
        }
        this.setGaugeSize(this.getSize());
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean value) {
        this.editable = value;
        if (this.editable) {
            this.addMouseMotionListener(this.dragGauge);
            this.addMouseListener(this.setGauge);
        } else {
            this.removeMouseMotionListener(this.dragGauge);
            this.removeMouseListener(this.setGauge);
        }
    }

    public double getRange() {
        return this.range;
    }

    public void setMin(double value) {
        this.min = value;
        this.minString = " " + this.min;
        this.range = Math.abs(this.max - this.min);
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double value) {
        this.max = value;
        this.maxString = " " + this.max;
        this.range = Math.abs(this.max - this.min);
    }

    public double getMax() {
        return this.max;
    }

    public void setScaleMax(int scale) {
        double value = ((double)scale - 50.0) / 10.0;
        this.max = Math.pow(10.0, value);
    }

    @Override
    public void updateValue(double value, int index) {
        this.values[index] = value;
        this.gaugeValues[index] = (int)(this.values[index] * (double)this.gaugeHeight / this.range);
        int i = index;
        while (i < this.numberOfBars) {
            Rectangle bar = this.bars[i];
            int gaugeValue = this.gaugeValues[i];
            bar.x = 0;
            bar.width = this.gaugeWidth;
            bar.height = gaugeValue;
            bar.y = i == 0 ? this.gaugeHeight - gaugeValue : this.bars[i - 1].y - bar.height;
            ++i;
        }
        this.repaint();
    }

    @Override
    public void updateValue(double value) {
        this.updateValue(value, 0);
    }

    @Override
    public void updateValue(float value, int index) {
        this.updateValue((double)value, index);
    }

    @Override
    public void updateValue(float value) {
        this.updateValue((double)value);
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public double getValue() {
        return this.values[0];
    }

    @Override
    public Color getColor(int index) {
        return this.barColors[index];
    }

    @Override
    public void setColor(Color color, int index) {
        this.barColors[index] = color;
    }

    public Color getColor() {
        return this.barColors[0];
    }

    public void setColor(Color color) {
        this.barColors[0] = color;
    }

    public void setMajorTickMarks(int ticks) {
        this.majorTicks = ticks;
        if (this.majorTicks > 0) {
            this.majorTickValue = this.gaugeHeight / this.majorTicks;
        }
        this.setMinorTickMarks(this.minorTicks);
    }

    public void setMinorTickMarks(int ticks) {
        this.minorTicks = ticks;
        if (this.minorTicks > 0) {
            this.minorTickValue = this.majorTickValue / this.minorTicks;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int i = 0;
        while (i < this.numberOfBars) {
            g.setColor(this.barColors[i]);
            g.fillRect(this.bars[i].x, this.bars[i].y, this.bars[i].width, this.bars[i].height);
            ++i;
        }
        if (this.drawBoundary) {
            g.setColor(Color.black);
            g.drawRect(0, 0, this.gaugeWidth, this.gaugeHeight);
        }
        if (this.majorTicks > 0 && this.minorTicks > 0) {
            int x1 = this.gaugeWidth + this.tickSpace;
            int y1 = this.gaugeHeight;
            while (y1 >= 0) {
                int x2 = x1 + this.majorTickLength;
                g.drawLine(x1, y1, x2, y1);
                x2 = x1 + this.minorTickLength;
                int min = y1 - this.majorTickValue + this.minorTickValue;
                int y2 = y1 - this.minorTickValue;
                while (y2 >= min) {
                    g.drawLine(x1, y2, x2, y2);
                    y2 -= this.minorTickValue;
                }
                y1 -= this.majorTickValue;
            }
            int x = x1 + this.majorTickLength + this.tickSpace;
            int i2 = 0;
            while (i2 < this.gaugeValues.length) {
                int y = this.gaugeHeight - this.gaugeValues[i2] + 10;
                g.drawString(this.valueStrings[i2], x, y);
                g.drawString(this.maxString, x, 10);
                g.drawString(this.minString, x, this.gaugeHeight + 10);
                ++i2;
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test gauge");
        Gauge gauge = new Gauge();
        gauge.setEditable(true);
        gauge.setNumberOfBars(6);
        frame.getContentPane().add((Component)gauge, "Center");
        frame.setSize(150, 500);
        frame.setVisible(true);
    }
}

