/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.concord.swing.graph.ValueGraph;

public class LineGraph
extends JComponent
implements ValueGraph {
    static final double DEFAULT_ORIGIN = 0.0;
    static final double DEFAULT_MAXIMUM = 100.0;
    static final int DEFAULT_CELL_SIZE = 20;
    protected Font smallFont = new Font("Arial", 0, 9);
    protected Image bi;
    protected Graphics big;
    protected int width = 0;
    protected int height = 0;
    protected Vector functions = new Vector();
    protected Vector visibleFunctions = new Vector();
    protected Vector colorList = new Vector();
    protected double yOrigin = 0.0;
    protected double yMax = 100.0;
    protected boolean showingNegative = false;
    protected int cellSize = 20;
    protected int cursorIndex = -1;
    protected Color cursorColor = Color.red;
    protected Color backColor;
    protected Color gridColor;
    protected Color textColor;
    protected boolean drawBoundsValues = false;
    protected DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance();
    protected ChangeListener sliderChanged = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            if (LineGraph.this.slider instanceof JSlider) {
                LineGraph.this.setScaleMax(LineGraph.this.slider.getMaximum() - LineGraph.this.slider.getValue());
            }
            LineGraph.this.repaint();
        }
    };
    protected JSlider slider;
    protected ComponentAdapter sizeChanged = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            LineGraph.this.setLineGraphSize(LineGraph.this.getSize());
        }
    };

    public LineGraph() {
        this.setBackColor(Color.black);
        this.setGridColor(new Color(0, 100, 0));
        this.setTextColor(Color.green);
        this.format.setMinimumFractionDigits(2);
        this.format.setMaximumFractionDigits(2);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.format.setDecimalFormatSymbols(dfs);
        this.addComponentListener(this.sizeChanged);
        this.drawBoundsValues = true;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public boolean isShowingNegative() {
        return this.showingNegative;
    }

    public int getCursorIndex() {
        return this.cursorIndex;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorIndex(int value) {
        this.cursorIndex = value;
    }

    public void setCursorColor(Color value) {
        this.cursorColor = value;
    }

    public void setShowingNegative(boolean negative) {
        this.showingNegative = true;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int cell) {
        this.cellSize = cell;
    }

    @Override
    public void setColor(Color color, int index) {
        int n = this.colorList.size();
        if (index >= n) {
            this.colorList.setSize(index + 1);
        }
        this.colorList.setElementAt(color, index);
    }

    @Override
    public Color getColor(int index) {
        Object object;
        int n = this.colorList.size();
        Color color = colors[index % colors.length];
        if (index < n && (object = this.colorList.elementAt(index)) instanceof Color) {
            return (Color)object;
        }
        return color;
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.setSlider(new JSlider());
        }
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        if (this.slider instanceof JSlider) {
            this.slider.removeChangeListener(this.sliderChanged);
        }
        this.slider = slider;
        if (this.slider instanceof JSlider) {
            this.slider.addChangeListener(this.sliderChanged);
        }
    }

    public void setYOrigin(double yOrigin) {
        this.yOrigin = yOrigin;
    }

    public void setYOrigin(float yOrigin) {
        this.setYOrigin((double)yOrigin);
    }

    public double getMax() {
        return this.yMax;
    }

    public void setMax(double yMax) {
        this.yMax = yMax;
    }

    public void setScaleMax(int scale) {
        double value = ((double)scale - 50.0) / 10.0;
        this.yMax = Math.pow(10.0, value);
    }

    protected double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public void setSliderValue() {
        int value = (int)(10.0 * this.log10(this.getMax()) + 50.0);
        value = this.slider.getMaximum() - value;
        if (value < 0) {
            value = 0;
        }
        this.slider.setValue(value);
    }

    public void setMax(float yMax) {
        this.setMax((double)yMax);
    }

    public void setBoundsValuesVisible(boolean visible) {
        this.drawBoundsValues = visible;
    }

    public void reset() {
        this.functions.removeAllElements();
        this.colorList.removeAllElements();
    }

    protected void setLineGraphSize(Dimension size) {
        this.bi = this.createImage(size.width, size.height);
    }

    protected double[] getFunction(int index, double x) {
        double[] function;
        int n = this.functions.size();
        if (index >= n) {
            this.functions.setSize(index + 1);
            this.visibleFunctions.setSize(index + 1);
        }
        if ((function = (double[])this.functions.elementAt(index)) == null) {
            function = new double[this.getSize().width];
            this.functions.setElementAt(function, index);
            this.visibleFunctions.setElementAt(function, index);
            int i = 0;
            while (i < function.length) {
                function[i] = x;
                ++i;
            }
        }
        return function;
    }

    public void setFunctionVisible(boolean visible, int index) {
        double[] function = this.getFunction(index, 0.0);
        this.visibleFunctions.setElementAt((double[])(visible ? function : null), index);
    }

    public boolean isFunctionVisible(int index) {
        return index < this.functions.size() && this.visibleFunctions.elementAt(index) != null;
    }

    @Override
    public void updateValue(double x, int index) {
        double[] function = this.getFunction(index, x);
        int i = 1;
        while (i < function.length) {
            function[i - 1] = function[i];
            ++i;
        }
        function[function.length - 1] = x;
        this.repaint();
    }

    @Override
    public void updateValue(double x) {
        this.updateValue(x, 0);
    }

    @Override
    public void updateValue(float x, int index) {
        this.updateValue((double)x, index);
    }

    @Override
    public void updateValue(float x) {
        this.updateValue((double)x);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        Dimension dim = this.getSize();
        this.width = dim.width;
        this.height = dim.height;
        int nx = this.width / this.cellSize + 1;
        int ny = this.height / this.cellSize + 1;
        if (this.bi == null) {
            this.bi = this.createImage(this.width, this.height);
        }
        this.big = this.bi.getGraphics();
        this.big.setColor(this.backColor);
        this.big.fillRect(0, 0, this.width, this.height);
        this.big.setColor(this.gridColor);
        int i = 0;
        while (i < nx) {
            this.big.drawLine(this.cellSize * i, 1, this.cellSize * i, this.height - 1);
            ++i;
        }
        i = 0;
        while (i < ny) {
            this.big.drawLine(1, this.cellSize * i, this.width - 1, this.cellSize * i);
            ++i;
        }
        double yUnit = this.showingNegative ? this.yOrigin + (double)this.height / (2.0 * this.yMax) : (double)this.height / this.yMax;
        double yMin = this.showingNegative ? -this.yMax : this.yOrigin;
        int f = 0;
        while (f < this.functions.size()) {
            Color fColor = this.getColor(f);
            this.big.setColor(fColor);
            double[] function = (double[])this.visibleFunctions.elementAt(f);
            if (function != null) {
                int x1 = 0;
                int y1 = (int)((this.yMax - function[0]) * yUnit);
                int i2 = 1;
                while (i2 < function.length) {
                    int x2 = i2;
                    int y2 = (int)((this.yMax - function[i2]) * yUnit);
                    this.big.drawLine(x1, y1, x2, y2);
                    if (i2 == this.cursorIndex) {
                        this.big.setColor(this.cursorColor);
                        this.big.drawLine(x1, 0, x1, this.height);
                        this.big.setColor(fColor);
                    }
                    x1 = x2;
                    y1 = y2;
                    ++i2;
                }
            }
            ++f;
        }
        if (this.drawBoundsValues) {
            this.big.setColor(this.textColor);
            if (this.showingNegative) {
                this.big.drawString(this.format.format(this.yOrigin), 0, this.height / 2);
            }
            this.big.drawString(this.format.format(this.yMax), 0, 15);
            this.big.drawString(this.format.format(yMin), 0, this.height);
        }
        g.drawImage(this.bi, 0, 0, null);
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        LineGraph graph = new LineGraph();
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)graph, "Center");
        frame.getContentPane().add((Component)graph.getSlider(), "South");
        graph.setShowingNegative(true);
        graph.setMax(2.0);
        frame.setSize(400, 300);
        frame.setVisible(true);
        double unit = 0.0314159;
        int i = 0;
        while (i < 400) {
            double sine = Math.sin(unit * (double)i);
            double cosine = Math.cos(unit * (double)i);
            graph.setCursorIndex(600 - i);
            graph.updateValue(sine, 0);
            graph.updateValue(cosine, 1);
            graph.updateValue(sine + cosine, 2);
            graph.sleep(50);
            ++i;
        }
    }
}

