/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVDateRevisionHandler
extends BasicDAVHandler {
    private long myRevisionNumber;

    public static StringBuffer generateDateRevisionRequest(StringBuffer xmlBuffer, Date date) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "dated-rev-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("D", "creationdate", SVNDate.formatDate(date), xmlBuffer);
        SVNXMLUtil.addXMLFooter("S", "dated-rev-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVDateRevisionHandler() {
        this.init();
        this.myRevisionNumber = -1L;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == DAVElement.VERSION_NAME && cdata != null) {
            try {
                this.myRevisionNumber = Long.parseLong(cdata.toString());
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        }
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
    }
}

